/*****************************
/* IE fast edition tools
/*****************************

/**
 * Get the path of a doc file using the path of the corresponding HTML file
 * @param htmlFilePath is the path of the HTML file
 * @return the path of the DOC file
 */
function getDocFilePath( htmlFilePath )
{
    // Remove file://, the anchor (#A1), and deduce the path of the .doc files
    var filePath = htmlFilePath.replace( "file://", "" );
    filePath = filePath.replace( "py_doc", "hxpython\\py_doc" );
    filePath = filePath.replace( "hxcelltrackingcore", "CellTracking\\core" );
    filePath = filePath.replace( "hxvolumescopeworkroom", "VolumeScope\\workroom");
    filePath = filePath.replace( "hxvolumescopegui", "VolumeScope\\gui");
    filePath = filePath.replace( "PythonProcessing", "VolumeScope\\PythonProcessing");
    filePath = filePath.replace( "product\\share\\doc\\html", "src\\core" );
    filePath = filePath.replace( RegExp( "#.*" ), "" );

    // Get exp matching the name of the file
    var fileregex = new RegExp( "((?!\\\\).)*\\.html" );
    var match = fileregex.exec( filePath );
    var htmlFileName = match[0];
    var docFileName = "doc\\" + htmlFileName.replace( ".html", ".doc" );
    filePath = filePath.replace( htmlFileName, docFileName );

    return filePath;
}

/**
 * Launch notepad++ with the doc file corresponding to the current HTML page
 */
function execNotepad()
{
    // Get the path of the doc file corresponding to the current html page
    var docFileName = getDocFilePath( document.URL );
    var texFileName = docFileName.replace( ".doc" , ".tex" );

    // If the .doc file exists, this file will be opened by notepad++.
    // Else, the .tex file will be opened.
    var wshShell = new ActiveXObject( "WScript.Shell" );
    var cmdLine = "IF EXIST " + docFileName + " (start notepad++.exe " + docFileName + ") ELSE start notepad++.exe " + texFileName;
    wshShell.Run( "cmd /c " + cmdLine, 1, true );
}

/**
 * Rebuild the doc file corresponding to the current HTML page
 */
function buildPage()
{
    // Get the path of the doc file corresponding to the current html page
    var docFileName = getDocFilePath( document.URL );

    // Get Avizo/Amira root path
    var rootPath = document.URL;
    rootPath = rootPath.replace( "file://", "" );
    var exeregex = new RegExp( "product.*" );
    match = exeregex.exec( rootPath );
    rootPath = rootPath.replace( match[0], "product" );

    // Deduce the path of doc2html executable (built in Optimize)
    var dochtmlPath = rootPath + "\\bin\\arch-Win64VC12-Optimize\\doc2html.exe"; //doc2html path
    var dochtmlCmd = dochtmlPath + " -skin AllSkins -d " + rootPath + "\\share\\doc\\html ";  // command line without the filename

    // If the .doc file exists, doc2html will build this file.
    // Else, the .tex file will be considered.
    var texFileName = docFileName.replace( ".doc" , ".tex" );
    var docBuildCmdLine = "IF EXIST " + docFileName + " (" + dochtmlCmd + docFileName + ") ELSE " + dochtmlCmd + texFileName; // command line to build the doc

    // This command line test if doc2html is correctly build.
    // If it is, the build of the .doc (or .tex) file is launched.
    // Else, we try to start doc2html - it will lead to an error since the file is not build.
    var cmdLine = "setx HX_DOC_REVIEW 1 & IF EXIST " + dochtmlPath + " (" + docBuildCmdLine + ") ELSE start " + dochtmlPath; //whole command line

    // Launch the doc file generation
    var wshShell = new ActiveXObject( "WScript.Shell" );
    wshShell.Run( "cmd /c " + cmdLine, 1, true );
    location.reload();
}
