"""Tracker class
   Provides helper methods to get objects added and deleted for the Avizo/Avizo pool.

Example
-------
A surface object is created by pressing button "Create Surface" in "Surface Cross Section" module
we get it as the newly added object in the pool
>>> from AppObjectsHelper import Tracker
>>> surf_cut_obj = hx_project.create('HxSurfaceCut')
>>> surf_cut_obj.ports.data.connect(hx_project.get('chocolate-bar.surf'))
>>> export_port = surf_cut_obj.ports.export
>>> create_surf_btn = export_port.buttons[0]
>>> new_objects_tracker = Tracker()
>>> create_surf_btn.hit = True
>>> surf_cut_obj.fire()
>>> new_objs_list = new_objects_tracker.get_added()
>>> new_surf = hx_project.get(new_objs_list[0])
>>> new_objects_tracker.reset()
>>> create_surf_btn.hit = True
>>> surf_cut_obj.fire()
>>> new_objs_list = new_objects_tracker.get_added()
>>> new_surf = hx_project.get(new_objs_list[0])
"""

import _hx_core

class Tracker():

    def __init__(self):
        self.reset()
        
    def get_list(self):
        """
        get_list: Get list of object added or removed from the object factory pool.
		
		Warning
		-------
		This method can be called just once after the cosntructor or after the call to the reset method
        
        Returns
        -------
        A string contaning the list of object added or removed from the object factory pool
		encoded this way
		[+/-] ObjectType ObjectName # #
        """	
        self._diff = _hx_core.hx_object_factory._end_base_pool_diff()
        return self._diff
        
    def get_added(self):
        """
        get_added: Get list of object added to the object factory pool after the last call the reset method
		
		Warning
		-------
		This method can be called just once after the cosntructor or after the call to the reset method
        
        Returns
        -------
        A list of the names of objects added to the pool
        """		
        return self._get_list('+')
        
    def get_deleted(self):
        """
        get_deleted: Get list of object removed from the object pool after the last call the reset method
		
		Warning
		-------
		This method can be called just once after the cosntructor or after the call to the reset method
        
        Returns
        -------
        A list of names of the objects removed from the pool
        """		
        return self._get_list('-')
        
    def _get_list(self, flag_char):
        self.get_list()
        output = []
        new_objs_list = self._diff.split('\n')
        for obj in new_objs_list:
            line = str(obj)
            if line and line[0] == flag_char:
                temp = obj.split(' ')
                name = temp[2]
                output.append(name)
        return output
        
    def reset(self):
        """
        get_deleted: Get list of object removed from the object pool after the last call toe reset method
		
		Warning
		-------
		This method can be called just once after the cosntructor or after the call to the reset method
        
        Returns
        -------
        A list of removed objects names
        """		
        _hx_core.hx_object_factory._begin_base_pool_diff()