"""Returns a list of all modules in downstream_connections of given object having the given type modules 
"""
import _hx_core

def get_downstream_modules_by_type(root_module, seek_type=None):
        """
        get_downstream_modules_by_type: Returns a list of all the given type modules in downstream_connections of given object.
        
        Returns
        -------
        A list of modules that are downstream connected to the root_module and are instances of seek_type
        
        Example
        -------
        An HxDisplaySurface surface view object is showing a surface chocholate-bar.surf.
        A surface cross section module is used and refers the same chocolate-bar.surf as data.
        We want to determine the Surface view (HxDisplaySurface) module connected to data used by this second module: 
        >>> import ConnectionNavigator
        >>> surf_cut_obj = hx_project.create('HxSurfaceCut')
        >>> surf_cut_obj.ports.data.connect(hx_project.get('chocolate-bar.surf'))
        >>> surf_data = surf_cut_obj.ports.data.source()
        >>> surf_viewer = ConnectionNavigator.get_downstream_modules_by_type(surf_data, 'HxDisplaySurface')
        >>> if surf_viewer is not None:
        >>>    surf_viewer[0].name
        """
        output = list()
        all_connected_modules = root_module.downstream_connections
        if seek_type is not None:
            for obj in all_connected_modules:
                if obj.get_owner()._cpp_classname == str(seek_type):
                    output.append(obj.get_owner())
        else:
            output = list(obj for obj in all_connected_modules) 
        return output