from _hx_core import _tcl_interp

def _pack_names(names):
    sum = ''
    for name in names:
        sum = sum + ' ' + name
    return sum[1:]

def set_parameter_bundle(obj, param_bundles):
    """Set a bundle of parameters

    Parameters
    ----------
    param_bundles: dict
        It is a dictionary containing information about the bundle (see example for more explanation).

    Returns
    -------
    Nothing

    Example
    -------
    >>> import ParamBundleWrapper
    >>> cluster_base = hx_object_factory.create('HxCluster')
    >>> cell_tracking_dict = { 'timestep1' : 1, 'timestep2' : 2 }
    >>> parameters = { 'CellTracking' : cell_tracking_dict }
    >>> ParamBundleWrapper.set_parameter_bundle(cluster_base, parameters)
    """	


    def _set_parameter_bundle(obj, ancesters, param_bundles):
        for key, val in param_bundles.items():
            if isinstance(val, dict):
                obj._tcl_interp('parameters %s newBundle %s' % (_pack_names(ancesters), key))
                _set_parameter_bundle(obj, ancesters + (key,), val)
            else:
                obj._tcl_interp('parameters %s setValue %s %s' % (_pack_names(ancesters), key, val))
                
    _set_parameter_bundle(obj, (), param_bundles)
    
def get_parameter_bundle(obj, param_bundles):
    """Get a bundle of parameters

    Parameters
    ----------
    param_bundles: dict
        It is a dictionary containing information about the bundle (see example for more explanation).

    Returns
    -------
    A dictionary (of dictionaries) containing the values of the parameters starting from the given input parameter bundle

    Example
    -------
    >>> import ParamBundleWrapper
    >>> get materials defined on HxSurface
    >>> surf_obj = hx_project.get('chocolate-bar.surf')
    >>> materials_dict = { }
    >>> parameters = { 'Materials' : materials_dict }
    >>> get_parameter_bundle(surf_obj, parameters)
    >>> chocolate_color = parameters['Materials']['Chocolate']['Color']
	>>> exterior_color = parameters['Materials']['Exterior']['Color']
    >>> parameters2 = { 'Materials' : { 'Exterior' : { 'Color' : 0 } } }
    >>> ParamBundleWrapper.get_parameter_bundle(surf_obj, parameters2)
    >>> exterior_color = parameters2['Materials']['Exterior']['Color']	
    """


    def _get_parameter_bundle(obj, ancesters, param_bundles):
        if len(param_bundles) > 0:
            for key, val in param_bundles.items():
                tcl_cmd = "parameters {} isBundle".format(_pack_names(ancesters) + ' ' + key)
                ret = obj._tcl_interp(tcl_cmd)
                if ret[:7] == 'invalid':
                    print('Error: wrong input param_bundles!')
                    return
                if ret == '1':
                    if isinstance(val, dict):
                        _get_parameter_bundle(obj, ancesters + (key,), val)
                    else:
                        temp = {}
                        _get_parameter_bundle(obj, ancesters + (key,), temp)
                        param_bundles[key] = temp
                else:
                    tcl_cmd = "parameters {} getValue".format(_pack_names(ancesters) + ' ' + key)
                    ret = obj._tcl_interp(tcl_cmd)
                    if ret[:7] == 'invalid':
                        print('Error: wrong input param_bundles!')
                        return            
                    param_bundles[key] = ret
        else:
            tcl_cmd = "parameters {} size".format(_pack_names(ancesters))
            ret = obj._tcl_interp(tcl_cmd)
            ldict = param_bundles
            for i in range(int(ret)):
                tcl_cmd = "parameters {} index {}".format(_pack_names(ancesters), i)
                ret = obj._tcl_interp(tcl_cmd)
                ldict[str(ret)]=0
                _get_parameter_bundle(obj, ancesters, ldict)
        
                    
    _get_parameter_bundle(obj, (), param_bundles)

