# from StdOutErrRedirector import *

import _hx_core
from _hx_core import hx_project
import time
import os

from functools import wraps


def timeit(func):
    @wraps(func)
    def timeit_wrapper(*args, **kwargs):
        start_time = time.perf_counter()
        result = func(*args, **kwargs)
        end_time = time.perf_counter()
        total_time = end_time - start_time
        print(f'\nFunction took {total_time:.4f} seconds\n')
        return result

    return timeit_wrapper


def mkdir_if_needed(dir_path):
    if not os.path.exists(dir_path):
        os.makedirs(dir_path)


def export_data(data, folder, file_basename, format_string, suffix):
    mkdir_if_needed(folder)
    base_filepath = folder + "/" + file_basename + suffix
    print("Saving ", base_filepath)
    data._tcl_interp(" exportData \"{}\" \"{}\"".format(format_string, base_filepath))


# Override print to let Amira GUI update console
_builtin_print = print


def print(*args, **kwargs):
    _builtin_print(*args, **kwargs)
    _hx_core._tcl_interp("processEvents")


def show_console(module, onoff=True):
    module.ports.showConsole.buttons[0].hit = onoff
    module.fire()
    _hx_core._tcl_interp("processEvents")


def is_toggle_on(p, item):
    for t in list(p.toggles):
        if t.label == item:
            return t.checked != 0
    return None


def get_text_value(p, item):
    for t in list(p.texts):
        if t.label == item:
            return t.value
    return None


def is_button_hit(p, item):
    for t in list(p.buttons):
        if t.caption == item:
            return t.hit
    return None


def selected_radio_box(p):
    return p.radio_boxes[p.selected].label


def select_button_menu(p, item, menu=0):
    try:
        index = p.menus[menu].options.index(item)
    except ValueError:
        return False
    p.menus[0].selected = index
    return True


def selected_button_menu(p, menu=0):
    selected = p.menus[menu].selected
    return p.menus[menu].options[selected]


def tcl_core_command(command):
    _hx_core._tcl_interp(command)

def tcl_module_command(module, command):
    return module._tcl_interp(command)

def create_module(module_type, visible=True):
    module = hx_project.create(module_type) if visible else _hx_core.hx_object_factory.create(module_type)
    module.icon_visible = visible
    return module
def set_module_result(module, result_data, name, discard_previous=False, result_slot=0):
    # Replace previous result if discard option is on
    if len(module.results) > result_slot and module.results[result_slot] is not None and discard_previous:
        previous_result = module.results[result_slot]
        icon_position = previous_result.icon_position
        previous_name = previous_result.name
        previous_result.name = "tmp"  # avoid name conflict
        previous_result.fire()
        # Move previous connections
        while len(previous_result.downstream_connections) > 0:
            connection = previous_result.downstream_connections[0]
            connection.connect(result_data)
        _hx_core.hx_project.remove(previous_result)
        module.results[result_slot] = result_data
        if result_data is not None:
            result_data.name = name  
            result_data.icon_position = icon_position # keep previous position
            result_data.touch(_hx_core.HxData.NEW_DATA)
            result_data.fire()
    elif result_data is not None:  # prepare adding new result unless None
        for slot in range(len(module.results), result_slot + 1):  # prepare missing slots as needed
            module.results.insert(slot, result_data)  # dummy insert requires a data object
            module.results[slot] = None  # set unused slots to None
        module.results[result_slot] = result_data
        result_data.name = name
